function [swap_curves, swap_dates, swap_maturities] = import_swap_curves()
% --------------------------------------------------------------------------------------------------
% Import historical interest rate swap curves. Use mid-price if available, and otherwise ask-price.
% --------------------------------------------------------------------------------------------------
% sample call: import_swap_curves();
% --------------------------------------------------------------------------------------------------

% Define ranges in Excel spreadsheet where data is located and corresponding maturities in years
ranges = {'A3:D2000', 'F3:I2000', 'K3:N2000', 'P3:S2000', 'U3:X2000', 'Z3:AC2000', 'AE3:AH2000', ...
          'AJ3:AM2000', 'AO3:AR2000', 'AT3:AW2000', 'AY3:BB2000', 'BD3:BG2000', 'BI3:BL2000', 'BN3:BQ2000'};
swap_maturities = [1/52 1/4 2/4 3/4 1 2 3 4 5 6 7 8 9 10]'; 

% Import data
num = {};
date = {};
for i=1:length(ranges)
    [num{i}, date{i}] = xlsread('c:/thesis/data/bloomberg/swap curves.xls', 1, ranges{i});
end

% Extract dates and prices (mid and if not available then ask, then bid)
for i=1:length(ranges)
    tmp = num{i};
    rates = zeros(size(tmp,1), 1);
    for j=1:length(rates)
        % Use right-most available column
        rates(j) = tmp(j, find(~isnan(tmp(j,:)), 1, 'last'));
    end
    num{i} = rates;
    date{i} = date{i}(:,1);
end

% Determine all available dates
all_date_nums = [];
for i=1:length(date)
    all_date_nums = union(all_date_nums, datenum(date{i}));
end
all_date_nums = sort(all_date_nums);
swap_dates = {};
for i=1:length(all_date_nums)
    swap_dates{i,1} = datestr(all_date_nums(i), 23);
end

% Determine for maturity, for each possible date the last available price
swap_curves = [];
for i=1:length(num)
    date_nums = datenum(date{i});
    available_pos = ismember(all_date_nums, date_nums);
    used_pos = max(1, cumsum(available_pos));
    used_prices = num{i}(used_pos);
    swap_curves = [swap_curves used_prices];
end